<livewire-publish-modal id="livewire-publish-modal">

	<!-- Modal Content -->
	  <div class="modal-dialog">
	    <div class="modal-content">
	      <div class="modal-header">
	        <h5 class="modal-title">Publish <?php echo e(ucfirst($selectedFileType)); ?></h5>
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          <span aria-hidden="true">&times;</span>
	        </button>
	      </div>
	      <div class="modal-body">
	      	<div class="form-group row">
                <label class="col-md-12 col-form-label" for="file-to-publish">What <?php echo e($selectedFileType); ?> do you want to publish?</label>
                <div class="col-md-12">
                  <select name="selectedFile" wire:model="selectedFile" class="form-control" id="file-to-publish">
              	    
                  	<?php $__currentLoopData = $visibleOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" wire:key="file_option_<?php echo e($loop->index); ?>"><?php echo e($option); ?></option>
                  	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
	              <div class="text-muted font-sm mt-4">This will copy-paste the blade file from the Backpack package to your <code><?php echo e($selectedFileTypePath); ?></code>, where you can customize it to fit your needs. Backpack will automatically use the published file if present. <br><br>Take into consideration that by publishing (aka overriding) a blade file, you will no longer get the updates for that blade file when you do <code>composer update</code>. For an easy-to-upgrade admin panel, it's recommended that you override blade files as little as possible. In most cases, it would be better to <i>rename</i> the file after it's been published, and only use it inside the Controllers/Views where strictly needed.</div>
                </div>
             </div>
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
	        <button type="button" class="btn btn-primary" wire:click="publishFile">Publish</button>
	      </div>
	    </div>
	  </div>

	  <?php echo $__env->make('backpack.devtools::livewire.partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	  <script>
	  	// when a menu item that triggers this modal is clicked, set
	  	// the value of selectedFileType to what the menu intended 
	  	// so that the dropdown gets populated with the blade
	  	// files for that type of file
		$("#devToolsNavBar a.dropdown-item[data-target='#livewire-publish-modal']").click(function() {
			window.livewire.find('<?php echo e($_instance->id); ?>').set('selectedFileType', $(this).data('file-type'));
			window.livewire.find('<?php echo e($_instance->id); ?>').set('showPublishModalAlerts', true);
			
		});

		// when the publish modal is closed toggle the visibility of the alerts
		$('#livewire-publish-modal').on('hidden.bs.modal', function () {
			window.livewire.find('<?php echo e($_instance->id); ?>').set('showPublishModalAlerts', false);
		});

	  </script>

</livewire-publish-modal>
<?php /**PATH /home/cp207323/public_html/chaisincanvas.com/website/vendor/backpack/devtools/src/../resources/views/livewire/modals/publish-modal.blade.php ENDPATH**/ ?>